package ru.yandex.partner.core.entity.page.type.allowedturbo;

import java.util.HashSet;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.PageWithAllowedTurbo;
import ru.yandex.partner.core.entity.page.repository.type.AbstractPageRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.utils.CommonConverters;
import ru.yandex.partner.dbschema.partner.tables.records.PagesRecord;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;
import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@ParametersAreNonnullByDefault
@Component
public class PageWithAllowedTurboRepositoryTypeSupport
        extends AbstractPageRepositoryTypeSupportWithMapper<PageWithAllowedTurbo, PagesRecord, PageOperationContainer> {
    private final JooqMapper<PageWithAllowedTurbo> mapper;
    private final ModelPropertiesHolder editableProperties;

    public PageWithAllowedTurboRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        mapper = JooqMapperBuilder.<PageWithAllowedTurbo>builder()
                .map(convertibleProperty(PageWithAllowedTurbo.ALLOWED_TURBO, PAGES.ALLOWED_TURBO,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .build();
        editableProperties = fromModelProperties(new HashSet<>(mapper.getWritableModelProperties()));
    }

    @Override
    public JooqMapper<PageWithAllowedTurbo> getJooqMapper() {
        return mapper;
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(PageWithAllowedTurbo model) {
        return editableProperties;
    }

    @Override
    public Class<PageWithAllowedTurbo> getTypeClass() {
        return PageWithAllowedTurbo.class;
    }
}
