package ru.yandex.partner.core.entity.page.type.assistants;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.jooq.DSLContext;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.dbschema.partner.tables.Assistants;

@Repository
public class PageWithAssistantsRepositoryHelper {

    public Map<Long, List<Assistant>> getAssistants(DSLContext dslContext, Collection<Long> pageIds) {

        return dslContext.select(Assistants.ASSISTANTS.USER_ID, Assistants.ASSISTANTS.PAGE_ID,
                Assistants.ASSISTANTS.CAN_EDIT)
                .from(Assistants.ASSISTANTS)
                .where(Assistants.ASSISTANTS.PAGE_ID.in(pageIds))
                .fetchGroups(
                        Assistants.ASSISTANTS.PAGE_ID,
                        record -> new Assistant()
                                .withUserId(record.get(Assistants.ASSISTANTS.USER_ID))
                                .withPageId(record.get(Assistants.ASSISTANTS.USER_ID))
                                .withCanEdit(record.get(Assistants.ASSISTANTS.CAN_EDIT) != 0)
                );

    }
}
