package ru.yandex.partner.core.entity.page.type.assistants;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.PageWithAssistants;
import ru.yandex.partner.core.entity.page.repository.type.AbstractPageRepositoryTypeSupport;
import ru.yandex.partner.core.entity.page.repository.type.PageRepositoryTypeSupportWithoutMapper;

import static ru.yandex.partner.core.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
@Component
public class PageWithAssistantsRepositoryTypeSupport
        extends AbstractPageRepositoryTypeSupport<PageWithAssistants, PageOperationContainer>
        implements PageRepositoryTypeSupportWithoutMapper<PageWithAssistants, PageOperationContainer> {
    private final PageWithAssistantsRepositoryHelper repositoryHelper;
    private final Set<ModelProperty<? super PageWithAssistants, ?>> affectedModelProperties;

    public PageWithAssistantsRepositoryTypeSupport(DSLContext dslContext,
                                                   PageWithAssistantsRepositoryHelper repositoryHelper) {
        super(dslContext);
        this.repositoryHelper = repositoryHelper;
        this.affectedModelProperties = Set.of(PageWithAssistants.ASSISTANTS);
    }

    @Override
    public Set<ModelProperty<? super PageWithAssistants, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<PageWithAssistants> models) {
        Map<Long, List<Assistant>> assistants =
                repositoryHelper.getAssistants(dslContext, mapList(models, PageWithAssistants::getId));

        for (PageWithAssistants model : models) {
            model.setAssistants(assistants.getOrDefault(model.getId(), List.of()));
        }
    }

    @Override
    public Class<PageWithAssistants> getTypeClass() {
        return PageWithAssistants.class;
    }
}
