package ru.yandex.partner.core.entity.page.type.base;

import java.util.HashSet;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.repository.type.AbstractPageRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.dbschema.partner.tables.records.PagesRecord;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;
import static ru.yandex.partner.dbschema.partner.tables.Pages.PAGES;

@ParametersAreNonnullByDefault
@Component
public class BasePageRepositoryTypeSupport extends
        AbstractPageRepositoryTypeSupportWithMapper<BasePage, PagesRecord, PageOperationContainer> {
    private final JooqMapper<BasePage> mapper;
    private final ModelPropertiesHolder editableProperties;

    public BasePageRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        mapper = JooqMapperBuilder.<BasePage>builder()
                .map(property(BasePage.ID, PAGES.ID))
                .build();
        editableProperties = fromModelProperties(new HashSet<>(mapper.getWritableModelProperties()));
    }

    @Override
    public JooqMapper<BasePage> getJooqMapper() {
        return mapper;
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(BasePage model) {
        return editableProperties;
    }

    @Override
    public Class<BasePage> getTypeClass() {
        return BasePage.class;
    }
}
