package ru.yandex.partner.core.entity.page.type.bkdata

import NPartner.Page.TPartnerPage
import org.springframework.stereotype.Component
import ru.yandex.direct.validation.builder.ItemValidationBuilder
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.constraint.NumberConstraints.notLessThan
import ru.yandex.direct.validation.result.Defect

@Component
class SlotValidatorProvider {
    fun validator() = Validator<TPartnerPage.TSlot, Defect<Any>> { slot ->
        ItemValidationBuilder.of<TPartnerPage.TSlot, Defect<Any>>(slot).apply {
            list(slot.sequencesList, "Sequences").checkEachBy(sequenceValidator())

            item(slot.slotID, "SlotID").check(
                notLessThan(0L), When.isTrue(slot.hasSlotID())
            )

            item(slot.total, "Total").check(
                notLessThan(0L), When.isTrue(slot.hasTotal())
            )

            item(slot.typeID, "TypeID").check(
                notLessThan(0L), When.isTrue(slot.hasTypeID())
            )
        }.result
    }

    private val knownSequenceTypes = setOf(
        "",
        "dynamic",
        "dynamic-right",
        "dynamic-south",
        "guarantee",
        "guarantee-right",
        "guarantee-south",
        "na",
        "premium",
        "visual",
    )

    fun sequenceValidator() = Validator<TPartnerPage.TSlot.TSequence, Defect<Any>> { seq ->
        val vb = ItemValidationBuilder.of<TPartnerPage.TSlot.TSequence, Defect<Any>>(seq)

        vb.item(seq.placeID, "PlaceID").check(
            notLessThan(1L), When.isTrue(seq.hasPlaceID())
        )

        vb.item(seq.placeSelect, "PlaceSelect").check(
            notLessThan(0L), When.isTrue(seq.hasPlaceSelect())
        )

        vb.item(seq.printSeqID, "PrintSeqID").check(
            notLessThan(1L), When.isTrue(seq.hasPrintSeqID())
        )

        vb.item(seq.printSlotID, "PrintSlotID").check(
            notLessThan(0L), When.isTrue(seq.hasPrintSlotID())
        )

        vb.item(seq.sequenceCheck, "SequenceCheck").check(
            notLessThan(0L), When.isTrue(seq.hasSequenceCheck())
        )

        vb.item(seq.sequenceID, "SequenceID").check(
            notLessThan(1L), When.isTrue(seq.hasSequenceID())
        )

        vb.item(seq.sequenceLimit, "SequenceLimit").check(
            notLessThan(0L), When.isTrue(seq.hasSequenceLimit())
        )

        vb.item(seq.sequenceType, "SequenceType").check(
            CommonConstraints.inSet(knownSequenceTypes),
            When.isTrue(seq.hasSequenceType())
        )

        vb.result
    }
}
