package ru.yandex.partner.core.entity.page.type.common;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.PageWithCommonFields;
import ru.yandex.partner.core.entity.page.repository.type.AbstractPageRepositoryTypeSupportWithMapper;
import ru.yandex.partner.dbschema.partner.tables.records.PagesRecord;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@ParametersAreNonnullByDefault
@Component
public class PageWithCommonFieldsRepositoryTypeSupport
        extends AbstractPageRepositoryTypeSupportWithMapper<PageWithCommonFields, PagesRecord, PageOperationContainer> {
    private final JooqMapper<PageWithCommonFields> mapper;

    protected PageWithCommonFieldsRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.mapper = JooqMapperBuilder.<PageWithCommonFields>builder()
                .map(property(PageWithCommonFields.PAGE_ID, PAGES.ID))
                .map(property(PageWithCommonFields.CAPTION, PAGES.CAPTION))
                .map(property(PageWithCommonFields.CREATE_DATE, PAGES.CREATE_DATE))
                .map(property(PageWithCommonFields.UPDATE_TIME, PAGES.UPDATE_TIME))
                .build();
    }

    @Override
    public JooqMapper<PageWithCommonFields> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<PageWithCommonFields> getTypeClass() {
        return PageWithCommonFields.class;
    }
}
