package ru.yandex.partner.core.entity.page.type.context;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.PageWithBlocksLimit;
import ru.yandex.partner.core.entity.page.repository.type.AbstractPageRepositoryTypeSupportWithMapper;
import ru.yandex.partner.dbschema.partner.tables.records.PagesRecord;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@ParametersAreNonnullByDefault
@Component
public class PageWithBlocksLimitRepositoryTypeSupport extends
        AbstractPageRepositoryTypeSupportWithMapper<PageWithBlocksLimit, PagesRecord, PageOperationContainer> {
    private final JooqMapper<PageWithBlocksLimit> mapper;

    public PageWithBlocksLimitRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);

        mapper = JooqMapperBuilder.<PageWithBlocksLimit>builder()
                .map(property(PageWithBlocksLimit.BLOCKS_LIMIT, PAGES.BLOCKS_LIMIT))
                .map(property(PageWithBlocksLimit.BLOCKS_COUNT, PAGES.BLOCKS_COUNT))
                .build();
    }

    @Override
    public JooqMapper<PageWithBlocksLimit> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<PageWithBlocksLimit> getTypeClass() {
        return PageWithBlocksLimit.class;
    }
}
