package ru.yandex.partner.core.entity.page.type.managers;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.jooq.DSLContext;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.dbschema.partner.tables.Managers;

@Repository
public class PageWithManagersRepositoryHelper {

    public Map<Long, List<Long>> getManagerIds(DSLContext dslContext, Collection<Long> pageIds) {
        return dslContext.select(Managers.MANAGERS.MANAGER_ID, Managers.MANAGERS.PAGE_ID)
                .from(Managers.MANAGERS)
                .where(Managers.MANAGERS.PAGE_ID.in(pageIds))
                .fetchGroups(Managers.MANAGERS.PAGE_ID, Managers.MANAGERS.MANAGER_ID);

    }
}
