package ru.yandex.partner.core.entity.page.type.managers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.PageWithManagers;
import ru.yandex.partner.core.entity.page.repository.type.AbstractPageRepositoryTypeSupport;
import ru.yandex.partner.core.entity.page.repository.type.PageRepositoryTypeSupportWithoutMapper;

import static ru.yandex.partner.core.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
@Component
public class PageWithManagersRepositoryTypeSupport
        extends AbstractPageRepositoryTypeSupport<PageWithManagers, PageOperationContainer>
        implements PageRepositoryTypeSupportWithoutMapper<PageWithManagers, PageOperationContainer> {

    private final PageWithManagersRepositoryHelper repositoryHelper;
    private final Set<ModelProperty<? super PageWithManagers, ?>> affectedModelProperties;

    public PageWithManagersRepositoryTypeSupport(DSLContext dslContext,
                                                 PageWithManagersRepositoryHelper pageWithManagersRepositoryHelper) {
        super(dslContext);
        this.repositoryHelper = pageWithManagersRepositoryHelper;
        this.affectedModelProperties = Set.of(PageWithManagers.MANAGER_IDS);
    }

    @Override
    public Set<ModelProperty<? super PageWithManagers, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<PageWithManagers> models) {
        Map<Long, List<Long>> map =
                repositoryHelper.getManagerIds(dslContext, mapList(models, PageWithManagers::getId));

        for (PageWithManagers model : models) {
            model.setManagerIds(map.getOrDefault(model.getId(), List.of()));
        }
    }

    @Override
    public Class<PageWithManagers> getTypeClass() {
        return PageWithManagers.class;
    }
}
