package ru.yandex.partner.core.entity.page.type.multistate;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.ExternalPageWithMultistate;
import ru.yandex.partner.core.multistate.page.ContextPageMultistate;
import ru.yandex.partner.core.multistate.page.PageMultistate;
import ru.yandex.partner.dbschema.partner.tables.records.PagesRecord;

@Component
@ParametersAreNonnullByDefault
public class ExternalPageWithMultistateRepositoryTypeSupport extends PageWithMultistateRepositoryTypeSupport<
        ExternalPageWithMultistate, PagesRecord, PageOperationContainer> {

    @Autowired
    public ExternalPageWithMultistateRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    protected PageMultistate getNewPageMultistate(Long multistateValue) {
        return new ContextPageMultistate(multistateValue);
    }


    @Override
    public Class<ExternalPageWithMultistate> getTypeClass() {
        return ExternalPageWithMultistate.class;
    }
}
