package ru.yandex.partner.core.entity.page.type.multistate;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.InternalMobileAppWithMultistate;
import ru.yandex.partner.core.multistate.page.InternalMobileAppMultistate;
import ru.yandex.partner.core.multistate.page.PageMultistate;
import ru.yandex.partner.dbschema.partner.tables.records.PagesRecord;

@Component
@ParametersAreNonnullByDefault
public class InternalMobileAppWithMultistateRepositoryTypeSupport extends PageWithMultistateRepositoryTypeSupport<
        InternalMobileAppWithMultistate, PagesRecord, PageOperationContainer> {

    @Autowired
    public InternalMobileAppWithMultistateRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    protected PageMultistate getNewPageMultistate(Long multistateValue) {
        return new InternalMobileAppMultistate(multistateValue);
    }

    @Override
    public Class<InternalMobileAppWithMultistate> getTypeClass() {
        return InternalMobileAppWithMultistate.class;
    }
}
