package ru.yandex.partner.core.entity.page.type.multistate;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.InternalPageWithMultistate;
import ru.yandex.partner.core.multistate.page.InternalContextPageMultistate;
import ru.yandex.partner.core.multistate.page.PageMultistate;
import ru.yandex.partner.dbschema.partner.tables.records.PagesRecord;

@Component
@ParametersAreNonnullByDefault
public class InternalPageWithMultistateRepositoryTypeSupport extends PageWithMultistateRepositoryTypeSupport<
        InternalPageWithMultistate, PagesRecord, PageOperationContainer> {

    @Autowired
    public InternalPageWithMultistateRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    protected PageMultistate getNewPageMultistate(Long multistateValue) {
        return new InternalContextPageMultistate(multistateValue);
    }

    @Override
    public Class<InternalPageWithMultistate> getTypeClass() {
        return InternalPageWithMultistate.class;
    }
}
