package ru.yandex.partner.core.entity.page.type.multistate;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.MobileAppSettingsWithMultistate;
import ru.yandex.partner.core.multistate.page.MobileAppSettingsMultistate;
import ru.yandex.partner.core.multistate.page.PageMultistate;
import ru.yandex.partner.dbschema.partner.tables.records.PagesRecord;

@Component
@ParametersAreNonnullByDefault
public class MobileAppWithMultistateRepositoryTypeSupport extends PageWithMultistateRepositoryTypeSupport<
        MobileAppSettingsWithMultistate, PagesRecord, PageOperationContainer> {

    @Autowired
    public MobileAppWithMultistateRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    protected PageMultistate getNewPageMultistate(Long multistateValue) {
        return new MobileAppSettingsMultistate(multistateValue);
    }

    @Override
    public Class<MobileAppSettingsWithMultistate> getTypeClass() {
        return MobileAppSettingsWithMultistate.class;
    }
}
