package ru.yandex.partner.core.entity.page.type.multistate;

import java.util.HashSet;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.page.model.PageWithMultistate;
import ru.yandex.partner.core.entity.page.repository.type.AbstractPageRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.multistate.AbstractMultistate;
import ru.yandex.partner.core.multistate.page.PageMultistate;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;
import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@ParametersAreNonnullByDefault
public abstract class PageWithMultistateRepositoryTypeSupport<P extends PageWithMultistate, R extends Record, PC>
        extends AbstractPageRepositoryTypeSupportWithMapper<P, R, PC> {
    private final JooqMapper<P> mapper;
    private final ModelPropertiesHolder editableProperties;

    public PageWithMultistateRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        mapper = JooqMapperBuilder.<P>builder()
                .map(convertibleProperty(PageWithMultistate.MULTISTATE, PAGES.MULTISTATE,
                        this::getNewPageMultistate, AbstractMultistate::toMultistateValue))
                .build();
        editableProperties = fromModelProperties(new HashSet<>(mapper.getWritableModelProperties()));
    }

    @Override
    public JooqMapper<P> getJooqMapper() {
        return mapper;
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(P model) {
        return editableProperties;
    }

    protected abstract PageMultistate getNewPageMultistate(Long multistateValue);
}
