package ru.yandex.partner.core.entity.page.type.site;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Table;
import org.jooq.TableField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.ExternalPageWithSite;
import ru.yandex.partner.core.utils.CommonConverters;
import ru.yandex.partner.dbschema.partner.tables.Site;
import ru.yandex.partner.dbschema.partner.tables.records.SiteRecord;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.dbschema.partner.Tables.SITE;

@Component
@ParametersAreNonnullByDefault
public class ExternalPageWithSiteRepositoryTypeSupport extends PageWithSiteRepositoryTypeSupport<
        ExternalPageWithSite, SiteRecord, PageOperationContainer> {

    private final JooqMapper<ExternalPageWithSite> siteMapper;

    @Autowired
    protected ExternalPageWithSiteRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.siteMapper = JooqMapperBuilder.<ExternalPageWithSite>builder()
                .map(convertibleProperty(ExternalPageWithSite.IS_GRAYSITE, SITE.IS_GRAYSITE,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .map(property(ExternalPageWithSite.DOMAIN, SITE.DOMAIN))
                .build();
    }

    @Override
    protected TableField<SiteRecord, Long> getSiteIdTableField() {
        return Site.SITE.ID;
    }

    @Override
    protected JooqMapper<ExternalPageWithSite> getSiteMapper() {
        return siteMapper;
    }

    @Override
    protected Table<SiteRecord> getSiteTable() {
        return Site.SITE;
    }

    @Override
    public Class<ExternalPageWithSite> getTypeClass() {
        return ExternalPageWithSite.class;
    }
}
