package ru.yandex.partner.core.entity.page.type.site;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Table;
import org.jooq.TableField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.InternalPageWithSite;
import ru.yandex.partner.dbschema.partner.tables.records.InternalSiteRecord;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.dbschema.partner.tables.InternalSite.INTERNAL_SITE;

@Component
@ParametersAreNonnullByDefault
public class InternalPageWithSiteRepositoryTypeSupport extends PageWithSiteRepositoryTypeSupport<
        InternalPageWithSite, InternalSiteRecord, PageOperationContainer> {

    private final JooqMapper<InternalPageWithSite> siteMapper;

    @Autowired
    protected InternalPageWithSiteRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.siteMapper = JooqMapperBuilder.<InternalPageWithSite>builder()
                .map(property(InternalPageWithSite.DOMAIN, INTERNAL_SITE.DOMAIN))
                .build();
    }

    @Override
    protected TableField<InternalSiteRecord, Long> getSiteIdTableField() {
        return INTERNAL_SITE.ID;
    }

    @Override
    protected JooqMapper<InternalPageWithSite> getSiteMapper() {
        return siteMapper;
    }

    @Override
    protected Table<InternalSiteRecord> getSiteTable() {
        return INTERNAL_SITE;
    }

    @Override
    public Class<InternalPageWithSite> getTypeClass() {
        return InternalPageWithSite.class;
    }
}
