package ru.yandex.partner.core.entity.page.type.store;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.Table;
import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.page.model.ExternalPageWithStore;
import ru.yandex.partner.core.multistate.page.MobileAppMultistate;
import ru.yandex.partner.core.multistate.page.PageStateFlag;
import ru.yandex.partner.dbschema.partner.tables.records.MobileAppRecord;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;
import static ru.yandex.partner.dbschema.partner.Tables.MOBILE_APP;
import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@Component
@ParametersAreNonnullByDefault
public class ExternalPageWithStoreRepositoryTypeSupport
        extends BasePageWithStoreRepositoryTypeSupport<ExternalPageWithStore> {

    public ExternalPageWithStoreRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext,
                JooqMapperBuilder.<ExternalPageWithStore>builder()
                        .map(property(ExternalPageWithStore.APPLICATION_ID, PAGES.DOMAIN_ID))
                        .build(),
                JooqMapperBuilder.<ExternalPageWithStore>builder()
                        .map(property(ExternalPageWithStore.STORE_ID, MOBILE_APP.STORE_ID))
                        .map(property(ExternalPageWithStore.APPLICATION_ID, MOBILE_APP.ID))
                        .map(property(ExternalPageWithStore.TYPE, MOBILE_APP.TYPE))
                        .readProperty(ExternalPageWithStore.DOMAIN, fromField(MOBILE_APP.STORE_ID).by(s -> s))
                        .readProperty(ExternalPageWithStore.IS_APP_APPROVED, fromField(MOBILE_APP.MULTISTATE).by(s ->
                                new MobileAppMultistate(s).hasFlag(PageStateFlag.APPROVED)))
                        .build()
        );
    }

    @NotNull
    protected TableField<MobileAppRecord, Long> getDomainIdField() {
        return MOBILE_APP.ID;
    }

    protected Table<?> getDomainTable() {
        return MOBILE_APP;
    }

    @Override
    public Class<ExternalPageWithStore> getTypeClass() {
        return ExternalPageWithStore.class;
    }
}
