package ru.yandex.partner.core.entity.page.type.store;

import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.Table;
import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.page.model.InternalPageWithStore;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;
import static ru.yandex.partner.dbschema.partner.Tables.PAGES;
import static ru.yandex.partner.dbschema.partner.tables.InternalMobileApp.INTERNAL_MOBILE_APP;

@Component
public class InternalPageWithStoreRepositoryTypeSupport extends
        BasePageWithStoreRepositoryTypeSupport<InternalPageWithStore> {

    public InternalPageWithStoreRepositoryTypeSupport(DSLContext dslContext) {
        super(
                dslContext,
                JooqMapperBuilder.<InternalPageWithStore>builder()
                        .map(property(InternalPageWithStore.APPLICATION_ID, PAGES.DOMAIN_ID))
                        .build(),
                JooqMapperBuilder.<InternalPageWithStore>builder()
                        .map(property(InternalPageWithStore.STORE_ID, INTERNAL_MOBILE_APP.STORE_ID))
                        .map(property(InternalPageWithStore.TYPE, INTERNAL_MOBILE_APP.TYPE))
                        .map(property(InternalPageWithStore.APPLICATION_ID, INTERNAL_MOBILE_APP.ID))
                        .readProperty(InternalPageWithStore.DOMAIN, fromField(INTERNAL_MOBILE_APP.STORE_ID).by(s -> s))
                        .build()
        );
    }

    @Override
    public Class<InternalPageWithStore> getTypeClass() {
        return InternalPageWithStore.class;
    }

    @NotNull
    @Override
    protected TableField<?, Long> getDomainIdField() {
        return INTERNAL_MOBILE_APP.ID;
    }

    @Override
    protected Table<?> getDomainTable() {
        return INTERNAL_MOBILE_APP;
    }
}
