package ru.yandex.partner.core.entity.page.type.unmoderatedrtbauction;

import java.util.HashSet;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.PageWithUnmoderatedRtbAuction;
import ru.yandex.partner.core.entity.page.repository.type.AbstractPageRepositoryTypeSupport;
import ru.yandex.partner.core.entity.page.repository.type.PageRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.utils.CommonConverters;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;
import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@ParametersAreNonnullByDefault
@Component
public class PageWithUnmoderatedRtbAuctionRepositoryTypeSupport extends
        AbstractPageRepositoryTypeSupport<PageWithUnmoderatedRtbAuction, PageOperationContainer> implements
        PageRepositoryTypeSupportWithMapper<PageWithUnmoderatedRtbAuction, PageOperationContainer> {
    private final JooqMapper<PageWithUnmoderatedRtbAuction> mapper;
    private final ModelPropertiesHolder editableProperties;

    public PageWithUnmoderatedRtbAuctionRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        mapper = JooqMapperBuilder.<PageWithUnmoderatedRtbAuction>builder()
                .map(convertibleProperty(
                        PageWithUnmoderatedRtbAuction.UNMODERATED_RTB_AUCTION, PAGES.UNMODERATED_RTB_AUCTION,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .build();
        editableProperties = fromModelProperties(new HashSet<>(mapper.getWritableModelProperties()));
    }

    @Override
    public JooqMapper<PageWithUnmoderatedRtbAuction> getJooqMapper() {
        return mapper;
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(PageWithUnmoderatedRtbAuction model) {
        return editableProperties;
    }

    @Override
    public Class<PageWithUnmoderatedRtbAuction> getTypeClass() {
        return PageWithUnmoderatedRtbAuction.class;
    }
}
