package ru.yandex.partner.core.entity.picategories;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.core.entity.DictRepository;
import ru.yandex.partner.dbschema.partner.tables.PicategoriesDict;
import ru.yandex.partner.dbschema.partner.tables.records.PicategoriesDictRecord;

import static ru.yandex.partner.dbschema.partner.tables.PicategoriesDict.PICATEGORIES_DICT;

@Repository
@ParametersAreNonnullByDefault
public class PiCategoriesDictRepository extends DictRepository<PicategoriesDictRecord> {

    @Override
    @Nonnull
    protected PicategoriesDict getTable() {
        return PICATEGORIES_DICT;
    }

    @Override
    @Nonnull
    protected TableField<PicategoriesDictRecord, Long> getIdField() {
        return getTable().CATEGORY_ID;
    }

}
