package ru.yandex.partner.core.entity.picategories;

import java.util.List;
import java.util.Map;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.impl.TableImpl;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.PiCategory;
import ru.yandex.partner.core.entity.picategories.filter.PiCategoriesModelFilterContainer;
import ru.yandex.partner.core.entity.simplemodels.AbstractSimpleRepositoryWithCommonMethods;
import ru.yandex.partner.dbschema.partner.tables.Picategories;
import ru.yandex.partner.dbschema.partner.tables.records.PicategoriesRecord;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.dbschema.partner.tables.Picategories.PICATEGORIES;

@Repository
@ParametersAreNonnullByDefault
public class PiCategoriesRepository extends AbstractSimpleRepositoryWithCommonMethods<PiCategory, PicategoriesRecord> {

    private final Map<String, Field<?>> dbFields;

    public PiCategoriesRepository(DSLContext dslContext, PiCategoriesModelFilterContainer modelFilterContainer) {
        super(dslContext,
                modelFilterContainer,
                createCommonMapper(),
                List.of(
                        Picategories.PICATEGORIES.PAGE_ID,
                        Picategories.PICATEGORIES.BLOCK_ID,
                        Picategories.PICATEGORIES.CATEGORY_ID
                ));
        this.dbFields = prepareDbFieldsMapping();
    }

    private static JooqMapper<PiCategory> createCommonMapper() {
        return JooqMapperBuilder.<PiCategory>builder()
                .map(property(PiCategory.PAGE_ID, PICATEGORIES.PAGE_ID))
                .map(property(PiCategory.BLOCK_ID, PICATEGORIES.BLOCK_ID))
                .map(property(PiCategory.ID, PICATEGORIES.CATEGORY_ID))
                .map(property(PiCategory.CPM, PICATEGORIES.CPM))
                .build();
    }

    private Map<String, Field<?>> prepareDbFieldsMapping() {
        return Map.of(
                PiCategory.PAGE_ID.name(), PICATEGORIES.PAGE_ID,
                PiCategory.BLOCK_ID.name(), PICATEGORIES.BLOCK_ID,
                PiCategory.ID.name(), PICATEGORIES.CATEGORY_ID,
                PiCategory.CPM.name(), PICATEGORIES.CPM);
    }

    @Override
    protected TableImpl<PicategoriesRecord> getTable() {
        return PICATEGORIES;
    }

    @Override
    protected Function<Record, PiCategory> fetchQueryFunction() {
        return r -> getMapper().fromDb(r, new PiCategory());
    }

    @Override
    protected Map<String, Field<?>> getDbFields() {
        return dbFields;
    }

    @Override
    protected Field<?> getIdField() {
        throw new UnsupportedOperationException(PICATEGORIES.getName() + " has not id field");
    }

    @Override
    protected Class<PiCategory> getModelClass() {
        return PiCategory.class;
    }
}
