package ru.yandex.partner.core.entity.picategories.filter;

import ru.yandex.partner.core.entity.block.model.PiCategory;
import ru.yandex.partner.core.filter.dbmeta.NumberFilter;

import static ru.yandex.partner.dbschema.partner.tables.Picategories.PICATEGORIES;

public class PiCategoryFilters {
    private PiCategoryFilters() {
    }

    public static <M extends PiCategory> NumberFilter<M, Long> id() {
        return new NumberFilter<>("id", PiCategory.class, PICATEGORIES.CATEGORY_ID);
    }

    public static <M extends PiCategory> NumberFilter<M, Long> pageId() {
        return new NumberFilter<>("page_id", PiCategory.class, PICATEGORIES.PAGE_ID);
    }

    public static <M extends PiCategory> NumberFilter<M, Long> blockId() {
        return new NumberFilter<>("block_id", PiCategory.class, PICATEGORIES.BLOCK_ID);
    }
}
