package ru.yandex.partner.core.entity.queue.service;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.queue.exceptions.TaskExecutionException;
import ru.yandex.partner.core.queue.Task;
import ru.yandex.partner.core.queue.TaskExecutionResult;

@Component
public class TaskQueueExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskQueueExecutor.class);
    private final TaskQueueService taskQueueService;

    @Autowired
    public TaskQueueExecutor(TaskQueueService taskQueueService) {
        this.taskQueueService = taskQueueService;
    }

    public <T extends Task<?, ?>> boolean doOneTask(Class<T> clazz) {
        Optional<Task<?, ?>> optionalTask = taskQueueService.grabTask(clazz);

        if (optionalTask.isPresent()) {
            Task<?, ?> task = optionalTask.get();

            try {
                Object result = task.execute();
                taskQueueService.finishTask(task, TaskExecutionResult.success(result));
            } catch (TaskExecutionException exception) {
                taskQueueService.finishTask(task, TaskExecutionResult.failure(exception.getErrorData(),
                        exception.getMessage()));
            } catch (Exception exception) {
                LOGGER.error("queue job failed with exception", exception);
                taskQueueService.finishTask(task, TaskExecutionResult.failure(exception.getMessage() == null ?
                        exception.toString() : exception.getMessage()));
            }

            return true;
        } else {
            return false;
        }
    }

    public <T extends Task<?, ?>> void doMultipleTask(Class<T> clazz, Integer multipleJobsLimit) {
        boolean taskPresent = true;
        while (multipleJobsLimit-- > 0 && taskPresent) {
            taskPresent = this.doOneTask(clazz);
        }
    }
}
