package ru.yandex.partner.core.entity.simplemodels;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.multitype.entity.LimitOffset;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.utils.OrderBy;

@ParametersAreNonnullByDefault
public interface SimpleRepository<M extends Model> {
    List<M> getAll(@NotNull CoreFilterNode<? super M> coreFilterNode,
                   @Nullable LimitOffset limitOffset,
                   @Nullable List<OrderBy> orderByList,
                   boolean forUpdate);

    List<M> createOrUpdate(List<M> entities);

    int insert(List<M> entities);

    int update(List<M> entities);

    void delete(Collection<M> currentModels);

    Long getCountByCondition(CoreFilterNode<M> coreFilterNode);

    <T1> Map<T1, Integer> getCountGroupedBy(String fieldName, @NotNull CoreFilterNode<M> coreFilterNode);

    <T1> Set<T1> existingIds(@NotNull CoreFilterNode<M> coreFilterNode);
}
