package ru.yandex.partner.core.entity.simplemodels.kvstorefrontend.service;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.kvstorefrontend.model.KvStoreFrontend;
import ru.yandex.partner.core.entity.simplemodels.AbstractSimpleService;
import ru.yandex.partner.core.entity.simplemodels.SimpleValidatorService;
import ru.yandex.partner.core.entity.simplemodels.kvstorefrontend.repository.KvStoreFrontendRepository;
import ru.yandex.partner.core.entity.tasks.doaction.DoActionFilterEnum;
import ru.yandex.partner.core.filter.meta.MetaFilter;

@ParametersAreNonnullByDefault
@Service
public class KvStoreFrontendService extends AbstractSimpleService<KvStoreFrontend> {

    @Autowired
    public KvStoreFrontendService(KvStoreFrontendRepository repository,
                                  SimpleValidatorService<KvStoreFrontend> validatorService) {
        super(
                KvStoreFrontend.class,
                repository,
                validatorService
        );
    }

    @Override
    protected Class<KvStoreFrontend> getModelClass() {
        return KvStoreFrontend.class;
    }

    @Override
    public ModelProperty<? extends Model, Long> getIdModelProperty() {
        return KvStoreFrontend.ID;
    }

    @Override
    public Class<KvStoreFrontend> getBaseClass() {
        return KvStoreFrontend.class;
    }

    @Override
    public <S extends KvStoreFrontend>
    MetaFilter<? super S, ?> getMetaFilterForDoAction(DoActionFilterEnum doActionFilterEnum) {

        throw new IllegalArgumentException("This service does not support " + doActionFilterEnum);
    }
}
