package ru.yandex.partner.core.entity.simplemodels.kvstorefrontend.service.validation.presentation;

import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.partner.core.entity.simplemodels.kvstorefrontend.service.validation.KvStoreDefect;
import ru.yandex.partner.libs.i18n.MsgWithArgs;
import ru.yandex.partner.libs.i18n.TranslatableError;

import static ru.yandex.partner.core.validation.defects.presentation.DefectPresentationProviders.getProvider;

public final class KvStoreFrontendDefectPresentationRegistry {
    private KvStoreFrontendDefectPresentationRegistry() {
        // utility
    }

    public static DefaultDefectPresentationRegistry<TranslatableError> kvStoreDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(KvStoreDefect.User.STORE_OVERFLOW,
                        getProvider(defectInfo -> MsgWithArgs.of(
                                KvStoreFrontendValidationMsg.STORE_OVERFLOW,
                                String.valueOf(defectInfo.getDefect().params())
                        ))
                )
                .build();
    }
}
