package ru.yandex.partner.core.entity.simplemodels.kvstorefrontend.service.validation.presentation;

import org.jetbrains.annotations.NotNull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum KvStoreFrontendValidationMsg implements GettextMsg {
    STORE_OVERFLOW(msg("Key-value store for user %s has reached it's maximum size"));

    public static final String KEYSET_NAME = "lib__Application__Model__Kv.pm";

    private final GettextMsgPayload payload;

    KvStoreFrontendValidationMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @NotNull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @NotNull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
