package ru.yandex.partner.core.entity.strategy;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;

import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.adtype.AdType;

import static ru.yandex.partner.core.CoreConstants.Strategies.MAX_REVENUE_STRATEGY_ID;
import static ru.yandex.partner.core.CoreConstants.Strategies.MIN_CPM_STRATEGY_ID;
import static ru.yandex.partner.core.CoreConstants.Strategies.SEPARATE_CPM_STRATEGY_ID;

@Service
public class StrategyDefaultsFieldsService {

    public StrategyDefaultsFieldsService() {
    }


    public List<String> getFields(
            Long strategyId,
            @Nullable Boolean isShowVideo,
            @Nullable Boolean isShowVideoApplicable
    ) {
        if (MIN_CPM_STRATEGY_ID.equals(strategyId)) {
            return List.of("mincpm");
        } else if (MAX_REVENUE_STRATEGY_ID.equals(strategyId)) {
            return List.of();
        } else if (SEPARATE_CPM_STRATEGY_ID.equals(strategyId)) {
            List<String> result = new ArrayList<>();
            result.addAll(AdType.TEXT.getStrategyFields());
            result.addAll(AdType.MEDIA.getStrategyFields());
            if (Boolean.TRUE.equals(isShowVideo) &&
                    Boolean.TRUE.equals(isShowVideoApplicable)) {
                result.addAll(AdType.VIDEO.getStrategyFields());
            }
            return result;
        } else {
            throw new IllegalArgumentException("Strategy with id %s is invalid".formatted(strategyId));
        }
    }
}
