package ru.yandex.partner.core.entity.tasks;

import java.io.IOException;
import java.time.Duration;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.user.service.UserService;
import ru.yandex.partner.core.messages.TaskTypeMsg;
import ru.yandex.partner.core.queue.TaskData;
import ru.yandex.partner.core.queue.TaskFactory;
import ru.yandex.partner.core.queue.TaskType;
import ru.yandex.partner.libs.i18n.GettextMsg;

@Service
public class EmailToProcessingTaskFactory implements TaskFactory<EmailToProcessingTask> {

    private final ObjectMapper objectMapper;
    private final UserService userService;

    @Autowired
    public EmailToProcessingTaskFactory(ObjectMapper objectMapper, UserService userService) {
        this.objectMapper = objectMapper;
        this.userService = userService;
    }

    @Override
    public Class<EmailToProcessingTask> getTaskClass() {
        return EmailToProcessingTask.class;
    }

    @Override
    public int getTypeId() {
        return TaskType.SEND_EMAIL_TO_PROCESSING.getTypeId();
    }

    @Override
    public EmailToProcessingTask fromTaskData(TaskData taskData) {
        try {
            EmailToProcessingTask.Payload payload = objectMapper.readValue(
                    taskData.getParams(),
                    EmailToProcessingTask.Payload.class
            );
            return new EmailToProcessingTask(payload, taskData, userService);
        } catch (IOException exception) {
            throw new RuntimeException("Failed to deserialize EmailToProcessingTask.Payload", exception);
        }
    }

    @Override
    public int getMaxTries() {
        return 3;
    }

    @Override
    public Duration getTryAfter() {
        return Duration.ofSeconds(60);
    }

    @Override
    public boolean isAllowConcurrentExecution() {
        return true;
    }

    @Override
    public GettextMsg getTitle() {
        return TaskTypeMsg.SEND_EMAIL_TO_PROCESSING;
    }
}
