package ru.yandex.partner.core.entity.tasks.convertcpm;

import java.time.Duration;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.user.type.cpm.CpmConversionFactory;
import ru.yandex.partner.core.queue.TaskData;
import ru.yandex.partner.core.queue.TaskFactory;
import ru.yandex.partner.core.queue.TaskType;
import ru.yandex.partner.libs.i18n.GettextMsg;

@Component
public class ConvertCpmTaskFactory implements TaskFactory<ConvertCpmTask> {
    private final ObjectMapper objectMapper;
    private final CpmConversionFactory cpmConversionFactory;

    public ConvertCpmTaskFactory(
            ObjectMapper objectMapper,
            CpmConversionFactory cpmConversionFactory
    ) {
        this.objectMapper = objectMapper;
        this.cpmConversionFactory = cpmConversionFactory;
    }

    @Override
    public Class<ConvertCpmTask> getTaskClass() {
        return ConvertCpmTask.class;
    }

    @Override
    public int getTypeId() {
        return TaskType.CONVERT_CPM_IN_USER_BLOCKS.getTypeId();
    }

    @Override
    public ConvertCpmTask fromTaskData(TaskData taskData) {
        return new ConvertCpmTask(taskData, objectMapper, cpmConversionFactory);
    }

    @Override
    public int getMaxTries() {
        return 3;
    }

    @Override
    public Duration getTryAfter() {
        return Duration.ofSeconds(60);
    }

    @Override
    public boolean isAllowConcurrentExecution() {
        return true;
    }

    @Override
    public GettextMsg getTitle() {
        return null;
    }
}
