package ru.yandex.partner.core.entity.tasks.doaction;

import java.time.Duration;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.factories.AllCustomPayloadActionsFactory;
import ru.yandex.partner.core.queue.TaskData;
import ru.yandex.partner.core.queue.TaskFactory;
import ru.yandex.partner.core.queue.TaskType;
import ru.yandex.partner.core.service.entitymanager.EntityManager;
import ru.yandex.partner.libs.i18n.GettextMsg;

@Component
public class DoActionTaskFactory implements TaskFactory<DoActionTask> {
    private final ActionPerformer actionPerformer;
    private final AllCustomPayloadActionsFactory factory;
    private final ObjectMapper objectMapper;
    private final EntityManager entityManager;
    private final ActionUserIdContext actionUserIdContext;

    @Autowired
    public DoActionTaskFactory(ActionPerformer actionPerformer,
                               AllCustomPayloadActionsFactory factory,
                               ObjectMapper objectMapper,
                               EntityManager entityManager, ActionUserIdContext actionUserIdContext) {
        this.actionPerformer = actionPerformer;
        this.factory = factory;
        this.objectMapper = objectMapper;
        this.entityManager = entityManager;
        this.actionUserIdContext = actionUserIdContext;
    }

    @Override
    public Class<DoActionTask> getTaskClass() {
        return DoActionTask.class;
    }

    @Override
    public int getTypeId() {
        return TaskType.DO_ACTION.getTypeId();
    }

    @Override
    public DoActionTask fromTaskData(TaskData taskData) {
        return new DoActionTask(actionPerformer, factory, objectMapper, taskData, entityManager, actionUserIdContext);
    }

    @Override
    public int getMaxTries() {
        return 3;
    }

    @Override
    public Duration getTryAfter() {
        return Duration.ofSeconds(60);
    }

    @Override
    public boolean isAllowConcurrentExecution() {
        return false;
    }

    @Override
    public GettextMsg getTitle() {
        return null;
    }
}
