package ru.yandex.partner.core.entity.user

import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.direct.multitype.typesupport.TypeSupportAffectionHelper
import ru.yandex.partner.core.entity.ModelCopyMapper
import ru.yandex.partner.core.entity.common.editablefields.EditableFieldsService
import ru.yandex.partner.core.entity.user.model.BaseUser
import ru.yandex.partner.core.entity.user.model.User
import ru.yandex.partner.core.entity.user.repository.type.UserRepositoryTypeSupportFacade
import ru.yandex.partner.core.multitype.service.validation.type.update.EditableFieldValidator

@Configuration
class UserConfiguration {

    @Bean
    fun userTypeSupportAffectionHelper(): TypeSupportAffectionHelper<BaseUser> {
        return TypeSupportAffectionHelper<BaseUser>(emptySet())
    }

    @Bean
    fun userEditableFieldsService(facade: UserRepositoryTypeSupportFacade,
                                  helper: TypeSupportAffectionHelper<BaseUser>): EditableFieldsService<BaseUser> {
        return EditableFieldsService<BaseUser>(facade, helper);
    }

    @Bean
    fun userEditableFieldValidator(editableFieldsService: EditableFieldsService<BaseUser>,
                                   mappers: List<ModelCopyMapper<out User>>): EditableFieldValidator<BaseUser> {
        return EditableFieldValidator(editableFieldsService = editableFieldsService,
            copyMappers = mappers
                .map { Pair(it.modelClass, it) }
                .toMap())
    }

}
