package ru.yandex.partner.core.entity.user.actions;

import java.util.Collection;

import ru.yandex.partner.core.action.AbstractTransitionActionWithModelProperty;
import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionModelContainerWithModelProperty;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.core.multistate.user.UserMultistate;
import ru.yandex.partner.core.multistate.user.UserStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

public abstract class UserAction extends AbstractTransitionActionWithModelProperty<User, UserStateFlag, Void> {

    @SuppressWarnings("ParameterNumber")
    public UserAction(ActionConfiguration<User, ?> parentFactory,
                      String name,
                      Collection<Long> ids,
                      MultistateGraph<User, UserStateFlag> multistateGraph,
                      ActionPerformer actionPerformer,
                      ActionErrorHandler<User> errorHandler) {
        super(parentFactory, name, ids, multistateGraph, actionPerformer, errorHandler);
    }

    @Override
    public Multistate<UserStateFlag> getMultistate(User user) {
        return user.getMultistate();
    }

    @Override
    public void setMultistate(ActionModelContainerWithModelProperty<User> container,
                              Multistate<UserStateFlag> multistate) {
        container.changeProperty(User.MULTISTATE, new UserMultistate(multistate.getEnabledFlags()));
    }

    @Override
    public Class<User> getEntityClass() {
        return User.class;
    }
}
