package ru.yandex.partner.core.entity.user.actions;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionContext;
import ru.yandex.partner.core.action.ActionModelContainerImpl;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.entity.user.actions.factories.UserEditFactory;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.multistate.user.UserStateFlag;
import ru.yandex.partner.defaultconfiguration.PartnerLocalDateTime;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

/**
 * Экшен блокировки пользователя.
 * TODO пока используется только в тестах, потребует доработок для целевого использования
 */
public class UserActionBlock extends UserAction {
    private final boolean tryPerformNestedEdit;
    private final UserEditFactory userEditFactory;

    @SuppressWarnings("checkstyle:parameternumber")
    public UserActionBlock(ActionConfiguration<User, ?> parentFactory,
                           String actionName,
                           Collection<Long> ids,
                           boolean tryPerformNestedEdit,
                           UserEditFactory userEditFactory,
                           MultistateGraph<User, UserStateFlag> multistateGraph,
                           ActionPerformer actionPerformer,
                           UserActionErrorHandler errorHandler) {
        super(parentFactory, actionName, ids, multistateGraph, actionPerformer, errorHandler);
        this.tryPerformNestedEdit = tryPerformNestedEdit;
        this.userEditFactory = userEditFactory;
    }

    @Override
    public void onAction(ActionContext<User, ActionModelContainerImpl<User>> ctx,
                         List<ActionModelContainerImpl<User>> containers) {
        if (!tryPerformNestedEdit) {
            return;
        }

        List<ModelChanges<User>> updateDates = containers.stream().map(c -> c.getItem().getId())
                .map(id -> new ModelChanges<>(id, User.class).process(PartnerLocalDateTime.now(), User.CREATE_DATE))
                .collect(Collectors.toList());

        doNestedActions(true, userEditFactory.edit(updateDates));
    }

    @Override
    public String getSerializedOpts(Long id) {
        return "";
    }
}
