package ru.yandex.partner.core.entity.user.actions;

import ru.yandex.partner.libs.multistate.action.ActionNameHolder;

public enum UserActionsEnum implements ActionNameHolder {
    ADD("add"),
    PROVIDE_CONTACTS("provide_contacts"),
    REQUEST_CREATE_IN_BANNER_STORE("request_create_in_banner_store"),
    CREATED_PARTNER_IN_BANNER_STORE("created_partner_in_banner_store"),
    SET_USER_ROLE("set_user_role"),
    REVOKE_ROLES("revoke_roles"),
    REQUEST_YAN_CONTRACT("request_yan_contract"),
    YAN_CONTRACT_READY("yan_contract_ready"),
    LINK_ADFOX_USER("link_adfox_user"),
    UNLINK_ADFOX_USER("unlink_adfox_user"),
    UNSUBSCRIBE_FROM_STAT_MONITORING_EMAILS("unsubscribe_from_stat_monitoring_emails"),
    EDIT("edit"),
    SET_EXCLUDED_DOMAINS("set_excluded_domains"),
    SET_EXCLUDED_PHONES("set_excluded_phones"),
    SET_BLOCKED("set_blocked"),
    RESET_BLOCKED("reset_blocked"),
    CHANGE_CONTRACT("change_contract");

    private final String actionName;

    UserActionsEnum(String actionName) {
        this.actionName = actionName;
    }

    @Override
    public String getActionName() {
        return actionName;
    }
}
