package ru.yandex.partner.core.entity.user.actions.factories;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.user.actions.UserActionBlock;
import ru.yandex.partner.core.entity.user.actions.UserActionsEnum;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.entity.user.multistate.UserMultistateGraph;

@Component
public class UserBlockConfigurationFactory extends SmartActionConfigurationFactory<User, UserActionBlock> {
    public UserBlockConfigurationFactory(UserMultistateGraph userMultistateGraph) {
        super(UserActionsEnum.SET_BLOCKED, userMultistateGraph, User.CREATE_DATE);
    }
}
