package ru.yandex.partner.core.entity.user.actions.factories;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.entity.user.actions.UserActionBlock;
import ru.yandex.partner.core.entity.user.actions.UserActionErrorHandler;
import ru.yandex.partner.core.entity.user.actions.UserActionsEnum;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.multistate.user.UserStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@Component
public class UserBlockFactory
        extends CustomPayloadActionFactory<User, UserActionBlock> {
    private final MultistateGraph<User, UserStateFlag> userMultistateGraph;
    // Demo action factory dependency, for testing
    private final UserEditFactory userEditFactory;
    private final ActionPerformer actionPerformer;
    private final UserActionErrorHandler errorHandler;

    @Autowired
    public UserBlockFactory(
            UserBlockConfigurationFactory configurationFactory,
            MultistateGraph<User, UserStateFlag> userMultistateGraph,
            UserEditFactory userEditFactory,
            ActionPerformer actionPerformer,
            UserActionErrorHandler errorHandler) {
        super(configurationFactory);
        this.userMultistateGraph = userMultistateGraph;
        this.userEditFactory = userEditFactory;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
    }

    @Override
    public UserActionBlock createAction(List<Long> ids, JsonNode payload) {
        return block(ids);
    }

    @Override
    public String getName() {
        return UserActionsEnum.SET_BLOCKED.getActionName();
    }

    // TODO пока используется только в тестах
    @VisibleForTesting
    public UserActionBlock block(Collection<Long> ids) {
        return block(ids, false);
    }

    @VisibleForTesting
    public UserActionBlock block(
            Collection<Long> ids,
            boolean tryPerformEdit) {
        return new UserActionBlock(getActionConfiguration(),
                getName(),
                ids,
                tryPerformEdit,
                userEditFactory,
                userMultistateGraph,
                actionPerformer,
                errorHandler
        );
    }

    @Override
    public Class<User> getModelClass() {
        return User.class;
    }
}
