package ru.yandex.partner.core.entity.user.actions.factories;

import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.user.actions.UserActionChangeContract;
import ru.yandex.partner.core.entity.user.actions.UserActionErrorHandler;
import ru.yandex.partner.core.entity.user.actions.UserActionsEnum;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.entity.user.multistate.UserMultistateGraph;

@Component
public class UserChangeContractFactory extends CustomPayloadActionFactory<User, UserActionChangeContract> {
    private final UserMultistateGraph userMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final UserActionErrorHandler errorHandler;

    @Autowired
    public UserChangeContractFactory(UserMultistateGraph userMultistateGraph,
                                     ActionPerformer actionPerformer,
                                     UserActionErrorHandler errorHandler) {
        super(new SmartActionConfigurationFactory<>(UserActionsEnum.CHANGE_CONTRACT, userMultistateGraph,
                User.CLIENT_ID));
        this.userMultistateGraph = userMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
    }

    @Override
    public String getName() {
        return UserActionsEnum.CHANGE_CONTRACT.getActionName();
    }

    @Override
    public Class<User> getModelClass() {
        return User.class;
    }

    @Override
    public UserActionChangeContract createAction(List<Long> ids, JsonNode payload) {
        return new UserActionChangeContract(
                getActionConfiguration(),
                getName(),
                ids,
                userMultistateGraph,
                actionPerformer,
                errorHandler
        );
    }
}
