package ru.yandex.partner.core.entity.user.actions.factories;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.ModelPayloadActionFactory;
import ru.yandex.partner.core.entity.IncomingFields;
import ru.yandex.partner.core.entity.user.actions.UserActionEdit;
import ru.yandex.partner.core.entity.user.actions.UserActionErrorHandler;
import ru.yandex.partner.core.entity.user.actions.UserActionsEnum;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.multistate.user.UserStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@Component
public class UserEditFactory
        extends ModelPayloadActionFactory<User, UserActionEdit> {
    private final MultistateGraph<User, UserStateFlag> userMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final ObjectMapper objectMapper;
    private final UserActionErrorHandler errorHandler;

    @Autowired
    public UserEditFactory(
            UserEditConfigurationFactory configurationFactory,
            MultistateGraph<User, UserStateFlag> userMultistateGraph,
            ActionPerformer actionPerformer, ObjectMapper objectMapper,
            UserActionErrorHandler errorHandler) {
        super(configurationFactory);
        this.userMultistateGraph = userMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.objectMapper = objectMapper;
        this.errorHandler = errorHandler;
    }

    @Override
    public UserActionEdit createAction(
            Collection<ModelChanges<? super User>> modelChanges,
            IncomingFields updatedFields
    ) {
        return edit(modelChanges);
    }

    @Override
    public String getName() {
        return UserActionsEnum.EDIT.getActionName();
    }

    public UserActionEdit edit(Collection<? extends ModelChanges<? super User>> modelChanges) {
        return new UserActionEdit(
                getActionConfiguration(),
                getName(),
                modelChanges.stream().map(it -> it.castModel(User.class)).collect(Collectors.toList()),
                userMultistateGraph, actionPerformer, objectMapper, errorHandler
        );
    }

    public UserActionEdit edit(ModelChanges<? super User> changes) {
        return edit(List.of(changes));
    }

    @Override
    public Class<User> getModelClass() {
        return User.class;
    }
}
