package ru.yandex.partner.core.entity.user.actions.log;

import org.jooq.DSLContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.log.AbstractActionsLogger;
import ru.yandex.partner.dbschema.partner.Tables;
import ru.yandex.partner.dbschema.partner.tables.records.UsersActionLogRecord;
import ru.yandex.partner.defaultconfiguration.PartnerLocalDateTime;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class UserActionsLogger extends AbstractActionsLogger<UsersActionLogRecord> {
    public UserActionsLogger(DSLContext dslContext, ActionUserIdContext actionUserIdContext) {
        super(dslContext, Tables.USERS_ACTION_LOG, actionUserIdContext);
    }

    @Override
    public UsersActionLogRecord getRecord(Long userId, Long modelId, long oldMultistate, String actionName,
                                          long newMultistate, String opts) {

        UsersActionLogRecord record = new UsersActionLogRecord();
        record.setDt(PartnerLocalDateTime.now());
        record.setUserId(userId);
        record.setElemId(modelId);
        record.setOldMultistate(oldMultistate);
        record.setNewMultistate(newMultistate);
        record.setAction(actionName);
        record.setOpts(opts);

        return record;
    }
}
