package ru.yandex.partner.core.entity.user.container;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.jetbrains.annotations.NotNull;

import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.entity.user.model.User;

public class UserContainerImpl implements UserContainer {
    private final ConcurrentHashMap<Class<? extends BaseUser>, Object> dictionaries;

    private UserContainerImpl() {
        this.dictionaries = new ConcurrentHashMap<>();
    }

    public static UserContainerImpl create() {
        return new UserContainerImpl();
    }

    @Override
    public int getShard() {
        return 0;
    }

    @Override
    public Class<? extends BaseUser> getRuntimeClass(@NotNull Long modelId) {
        return User.class;
    }

    @Override
    public Map<Class<? extends BaseUser>, Object> getDictionaries() {
        return dictionaries;
    }

    @Override
    public void addDictionary(Class<? extends BaseUser> key, Object value) {
        dictionaries.put(key, value);
    }
}
