package ru.yandex.partner.core.entity.user.filter;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.container.DefaultModelFilterContainer;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.dbmeta.NumberFilter;
import ru.yandex.partner.core.filter.dbmeta.SubFilter;

import static ru.yandex.partner.dbschema.partner.tables.UserAdfox.USER_ADFOX;
import static ru.yandex.partner.dbschema.partner.tables.Users.USERS;

public class AdfoxMemberFilter<M> extends SubFilter<M, ModelWithId, Long> {
    public AdfoxMemberFilter(String name, Class<? super M> modelClass) {
        super(name, modelClass, USERS.ID, USER_ADFOX.USER_ID,
                new NumberFilter<>("sub", FilterType.DICTIONARY, ModelWithId.class, USER_ADFOX.ADFOX_ID));
    }

    @Override
    protected ModelFilterContainer<ModelWithId> getModelFilterContainer() {
        return new DefaultModelFilterContainer<>();
    }
}
