package ru.yandex.partner.core.entity.user.filter;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.QuantifiedSelect;
import org.jooq.Record1;
import org.jooq.impl.DSL;

import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.dbmeta.BaseFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.core.filter.utils.FilterUtils;

import static ru.yandex.partner.dbschema.partner.tables.BusinessRules.BUSINESS_RULES;
import static ru.yandex.partner.dbschema.partner.tables.Users.USERS;

public class HasBusinessRuleFilter<M> extends BaseFilter<M, Boolean> {

    public HasBusinessRuleFilter(String name, Class<? super M> modelClass) {
        super(name, FilterType.BOOLEAN, modelClass, Boolean.class);
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<Boolean> value) {
        Boolean aBoolean = FilterUtils.getSingleValueOrThrow(value, operator);

        QuantifiedSelect<Record1<Long>> quantifiedSelect =
                DSL.any(
                        DSL.selectDistinct(BUSINESS_RULES.OWNER_ID)
                                .from(BUSINESS_RULES)
                );

        return aBoolean
                ? USERS.ID.eq(quantifiedSelect)
                : USERS.ID.ne(quantifiedSelect);
    }
}
