package ru.yandex.partner.core.entity.user.filter;

import java.util.Collection;

import org.jooq.Condition;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.dbmeta.BaseFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.core.filter.utils.FilterUtils;

import static ru.yandex.partner.dbschema.partner.tables.Users.USERS;

public class IsYandexFilter<M> extends BaseFilter<M, Boolean> {
    private static final Long ADINSIDE_USER_ID = CoreConstants.ADINSIDE_USER_ID;

    public IsYandexFilter(String name, Class<? super M> modelClass) {
        super(name, FilterType.BOOLEAN, modelClass, Boolean.class);
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<Boolean> value) {
        Boolean aBoolean = FilterUtils.getSingleValueOrThrow(value, operator);
        return aBoolean
                ? USERS.ID.eq(ADINSIDE_USER_ID)
                : USERS.ID.ne(ADINSIDE_USER_ID);
    }
}
