package ru.yandex.partner.core.entity.user.filter;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.TableField;
import org.jooq.impl.DSL;

import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.dbmeta.BaseFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;

import static ru.yandex.partner.dbschema.partner.Tables.USERS;

public class ModerationReasonFilter<M> extends BaseFilter<M, Long> {

    public ModerationReasonFilter(String name, Class<? super M> modelClass) {
        super(name, FilterType.DICTIONARY, modelClass, Long.class);
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<Long> values) {
        return switch (operator) {
            case IN, EQUALS -> getCondition(values);
            case NOT_IN, NOT_EQUALS -> getCondition(values).not();
            default -> throw new IllegalArgumentException("Unsupported operator. FilterOperator = "
                    .concat(operator.name()).concat(" Class = ").concat(getClass().getName()));
        };
    }

    private Condition getCondition(Collection<Long> values) {
        TableField<UsersRecord, String> tableField = USERS.OPTS;
        return values.stream().map(value -> DSL.condition("JSON_CONTAINS({0},{1},'$" +
                        ".moderation_reason')", tableField, value.toString()))
                .reduce(Condition::or)
                .orElseThrow(() -> new IllegalArgumentException("No value provided"));
    }
}
