package ru.yandex.partner.core.entity.user.filter;

import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.dbmeta.BooleanFilter;
import ru.yandex.partner.core.filter.dbmeta.DateTimeFilter;
import ru.yandex.partner.core.filter.dbmeta.NumberFilter;
import ru.yandex.partner.core.filter.dbmeta.StringFilter;
import ru.yandex.partner.core.filter.meta.MatchMetaFilter;
import ru.yandex.partner.core.filter.meta.MultistateMetaFilter;
import ru.yandex.partner.core.multistate.user.UserStateFlag;

import static ru.yandex.partner.dbschema.partner.tables.Users.USERS;

public class UserFilters {

    public static final NumberFilter<BaseUser, Long> ID = new NumberFilter<>("id", BaseUser.class, USERS.ID);

    public static final NumberFilter<BaseUser, Long> UID = new NumberFilter<>("uid", BaseUser.class, USERS.UID);

    public static final NumberFilter<BaseUser, Long> CLIENT_ID = new NumberFilter<>("client_id", BaseUser.class,
            USERS.CLIENT_ID);

    public static final StringFilter<BaseUser> LOGIN = new StringFilter<>("login", FilterType.LOGIN, BaseUser.class,
            USERS.LOGIN);

    public static final StringFilter<BaseUser> NAME = new StringFilter<>("name", BaseUser.class, USERS.NAME);

    public static final StringFilter<BaseUser> LASTNAME = new StringFilter<>("lastname", BaseUser.class,
            USERS.LASTNAME);

    public static final StringFilter<BaseUser> EMAIL = new StringFilter<>("email", BaseUser.class, USERS.EMAIL);

    public static final StringFilter<BaseUser> PHONE = new StringFilter<>("phone", BaseUser.class, USERS.PHONE);

    public static final StringFilter<BaseUser> ACCOUNTANT_EMAIL = new StringFilter<>("accountant_email",
            BaseUser.class, USERS.ACCOUNTANT_EMAIL);

    public static final StringFilter<BaseUser> DOMAIN_LOGIN = new StringFilter<>("domain_login",
            BaseUser.class, USERS.DOMAIN_LOGIN);

    public static final BooleanFilter<BaseUser> NEWSLETTER = new BooleanFilter<>("newsletter",
            BaseUser.class, USERS.NEWSLETTER);

    public static final BooleanFilter<BaseUser> IS_TUTBY = new BooleanFilter<>("is_tutby", BaseUser.class,
            USERS.IS_TUTBY);

    public static final BooleanFilter<BaseUser> HAS_TUTBY_AGREEMENT = new BooleanFilter<>("has_tutby_agreement",
            BaseUser.class, USERS.HAS_TUTBY_AGREEMENT);

    public static final BooleanFilter<BaseUser> HAS_COMMON_OFFER = new BooleanFilter<>("has_common_offer",
            BaseUser.class, USERS.HAS_COMMON_OFFER);

    public static final BooleanFilter<BaseUser> BUSINESS_UNIT = new BooleanFilter<>("business_unit", BaseUser.class,
            USERS.BUSINESS_UNIT);

    public static final BooleanFilter<BaseUser> NO_STAT_MONITORING_EMAILS = new BooleanFilter<>(
            "no_stat_monitoring_emails", BaseUser.class, USERS.NO_STAT_MONITORING_EMAILS);

    public static final BooleanFilter<BaseUser> NEED_TO_EMAIL_PROCESSING = new BooleanFilter<>(
            "need_to_email_processing", BaseUser.class, USERS.NEED_TO_EMAIL_PROCESSING);

    public static final BooleanFilter<BaseUser> IS_ADFOX_PARTNER = new BooleanFilter<>("is_adfox_partner",
            BaseUser.class, USERS.IS_ADFOX_PARTNER);

    public static final UserTypeFilter<BaseUser> USER_TYPE = new UserTypeFilter<>("user_type", BaseUser.class);

    public static final IsYandexFilter<BaseUser> IS_YANDEX_FILTER = new IsYandexFilter<>("is_yandex_filter",
            BaseUser.class);

    public static final RoleMemberFilter<BaseUser> ROLE_ID = new RoleMemberFilter<>("role_id", BaseUser.class);

    public static final AdfoxMemberFilter<BaseUser> ADFOX_ID = new AdfoxMemberFilter<>("adfox_id", BaseUser.class);

    public static final HasBusinessRuleFilter<BaseUser> HAS_BUSINESS_RULE = new HasBusinessRuleFilter<>(
            "has_business_rule",
            BaseUser.class);

    public static final MultistateMetaFilter<BaseUser, UserStateFlag> MULTISTATE = new MultistateMetaFilter<>(
            "multistate", BaseUser.class);

    public static final ModerationReasonFilter<BaseUser> MODERATION_REASON_FILTER = new ModerationReasonFilter<>(
            "moderation_reason_filter", BaseUser.class);

    public static final MatchMetaFilter<BaseUser, BasePage> PAGE = new MatchMetaFilter<>("page", BaseUser.class);

    public static final BooleanFilter<BaseUser> IS_DELETED = new BooleanFilter<>("is_deleted", BaseUser.class,
            USERS.IS_DELETED);

    public static final DateTimeFilter<BaseUser> DELETION_DATE = new DateTimeFilter<>("deletion_date",
            BaseUser.class, USERS.DELETION_DATE);

    private UserFilters() {
    }
}
