package ru.yandex.partner.core.entity.user.filter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.entity.user.multistate.UserMultistateGraph;
import ru.yandex.partner.core.filter.db.MultistateDbFilter;
import ru.yandex.partner.core.multistate.user.UserStateFlag;
import ru.yandex.partner.dbschema.partner.Tables;

@Component
public class UserMultistateDbFilter extends MultistateDbFilter<User, UserStateFlag> {

    @Autowired
    public UserMultistateDbFilter(UserMultistateGraph multistateGraph) {
        super(UserFilters.MULTISTATE, User.class, multistateGraph, Tables.USERS.MULTISTATE);
    }
}
