package ru.yandex.partner.core.entity.user.filter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.filter.all.AllPagesModel;
import ru.yandex.partner.core.entity.page.filter.all.AllPagesModelFilterContainer;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.tables.AllPages;
import ru.yandex.partner.dbschema.partner.tables.Users;

@Component
public class UserPageMatchDbFilter extends MatchDbFilter<BaseUser, BasePage, AllPagesModel> {

    private AllPagesModelFilterContainer allPagesModelFilterContainer;

    @Autowired
    public UserPageMatchDbFilter() {
        super(UserFilters.PAGE, BaseUser.class, AllPagesModel.class, Users.USERS.ID, AllPages.ALL_PAGES.OWNER_ID);
    }

    @Autowired
    public void setAllPagesModelFilterContainer(AllPagesModelFilterContainer allPagesModelFilterContainer) {
        this.allPagesModelFilterContainer = allPagesModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<AllPagesModel> getModelFilterContainer() {
        return allPagesModelFilterContainer;
    }
}
