package ru.yandex.partner.core.entity.user.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.jooq.TableField;

import ru.yandex.partner.core.messages.UserTypeMsg;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;
import ru.yandex.partner.libs.i18n.GettextMsg;

import static ru.yandex.partner.dbschema.partner.tables.Users.USERS;

public enum UserType {
    IS_TUTBY(1L, USERS.IS_TUTBY, "users_view_field__is_tutby", UserTypeMsg.PARTNER_TUT_BY),
    IS_MOBILE_MEDIATION(2L, USERS.IS_MOBILE_MEDIATION, "users_view_field__is_mobile_mediation",
            UserTypeMsg.MOBILE_MEDIATOR),
    IS_ADFOX_PARTNER(3L, USERS.IS_ADFOX_PARTNER, null, UserTypeMsg.ADFOX_USER),
    IS_VIDEO_BLOGGER(4L, USERS.IS_VIDEO_BLOGGER, "users_view_field__is_video_blogger", UserTypeMsg.VIDEO_BLOGGER),
    IS_GAMES(5L, USERS.IS_GAMES, "users_view_field__is_games", UserTypeMsg.GAMES),
    IS_EFIR_BLOGGER(6L, USERS.IS_EFIR_BLOGGER, "users_view_field__is_efir_blogger", UserTypeMsg.EFIR_BLOGGER);

    private static final Map<Long, UserType> MAP = Arrays.stream(UserType.values())
            .collect(Collectors.toMap(UserType::getId, Function.identity()));

    private final Long id;
    private final TableField<UsersRecord, Long> field;
    private final String viewRightName;
    private final GettextMsg label;

    UserType(Long id, TableField<UsersRecord, Long> field, String viewRightName, GettextMsg label) {
        this.id = id;
        this.field = field;
        this.viewRightName = viewRightName;
        this.label = label;
    }

    public Long getId() {
        return id;
    }

    public TableField<UsersRecord, Long> getField() {
        return field;
    }

    public String getViewRightName() {
        return viewRightName;
    }

    public GettextMsg getLabel() {
        return label;
    }

    public static Collection<UserType> getUserTypes(Collection<Long> userTypeIds) {
        return userTypeIds.stream().map(MAP::get).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}
