package ru.yandex.partner.core.entity.user.filter;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.TableField;
import org.jooq.impl.DSL;

import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.dbmeta.BaseFilter;
import ru.yandex.partner.core.filter.operator.BinaryOperator;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;

public class UserTypeFilter<M> extends BaseFilter<M, UserType> {

    public UserTypeFilter(String name, Class<? super M> modelClass) {
        super(name, FilterType.DICTIONARY, modelClass, UserType.class);
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<UserType> value) {

        final boolean isEquality = isEquality(operator);

        long filterValue = isEquality ? 1L : 0L;
        BinaryOperator binaryOperator = isEquality ? BinaryOperator.OR : BinaryOperator.AND;
        Condition sumCondition = isEquality ? DSL.falseCondition() : DSL.trueCondition();

        for (UserType userType : value) {
            TableField<UsersRecord, Long> tableField = userType.getField();
            Condition condition = tableField.eq(filterValue);
            sumCondition = binaryOperator.doOperation(sumCondition, condition);
        }

        return sumCondition;
    }

    private boolean isEquality(FilterOperator operator) {
        return switch (operator) {
            case EQUALS, IN -> true;
            case NOT_EQUALS, NOT_IN -> false;
            default -> throw new IllegalArgumentException("Unsupported operator. FilterOperator = "
                    .concat(operator.name()));
        };
    }
}
